#!/usr/bin/env bash

# Parameters
env_names=("LunarLanderContinuous-v2" "Hopper-v2" "Walker2d-v2" "Ant-v2" "HalfCheetah-v2")
count=0

# Log file for job submissions
log_file="job_submission_log.txt"
> $log_file  # Clear the log file at the start

for env_name in "${env_names[@]}"; do
    # Check if the model already exists
      sbatch --job-name="eval_${env_name}" eval_env.sh $env_name
      echo "Submitted job for env=$env_name" | tee -a $log_file
      count=$((count + 1))
done

echo "Launched $count jobs."
